/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;

public class BlockInfo {
    private static final Direction[] SIDES = Direction.values();
    private final BlockColors colors;
    private IBlockDisplayReader world;
    private BlockState state;
    private BlockPos blockPos;
    private final boolean[][][] t = new boolean[3][3][3];
    private final int[][][] s = new int[3][3][3];
    private final int[][][] b = new int[3][3][3];
    private final float[][][][] skyLight = new float[3][2][2][2];
    private final float[][][][] blockLight = new float[3][2][2][2];
    private final float[][][] ao = new float[3][3][3];
    private final int[] packed = new int[7];
    private boolean full;
    private int cachedTint = -1;
    private int cachedMultiplier = -1;

    public BlockInfo(BlockColors colors) {
        this.colors = colors;
    }

    public int getColorMultiplier(int tint) {
        if (this.cachedTint == tint) {
            return this.cachedMultiplier;
        }
        this.cachedTint = tint;
        this.cachedMultiplier = this.colors.func_228054_a_(this.state, this.world, this.blockPos, tint);
        return this.cachedMultiplier;
    }

    @Deprecated
    public void updateShift() {
    }

    public void setWorld(IBlockDisplayReader world) {
        this.world = world;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
    }

    public void setState(BlockState state) {
        this.state = state;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
    }

    public void setBlockPos(BlockPos blockPos) {
        this.blockPos = blockPos;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
    }

    public void reset() {
        this.world = null;
        this.state = null;
        this.blockPos = null;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
    }

    private float combine(int c, int s1, int s2, int s3, boolean t0, boolean t1, boolean t2, boolean t3) {
        if (c == 0 && !t0) {
            c = Math.max(0, Math.max(s1, s2) - 1);
        }
        if (s1 == 0 && !t1) {
            s1 = Math.max(0, c - 1);
        }
        if (s2 == 0 && !t2) {
            s2 = Math.max(0, c - 1);
        }
        if (s3 == 0 && !t3) {
            s3 = Math.max(0, Math.max(s1, s2) - 1);
        }
        return (float)(c + s1 + s2 + s3) / 60.0f;
    }

    public void updateLightMatrix() {
        int z;
        int y;
        for (int x = 0; x <= 2; ++x) {
            for (y = 0; y <= 2; ++y) {
                for (z = 0; z <= 2; ++z) {
                    BlockPos pos = this.blockPos.func_177982_a(x - 1, y - 1, z - 1);
                    BlockState state = this.world.func_180495_p(pos);
                    this.t[x][y][z] = state.func_200016_a((IBlockReader)this.world, pos) < 15;
                    int brightness = WorldRenderer.func_228421_a_((IBlockDisplayReader)this.world, (BlockPos)pos);
                    this.s[x][y][z] = LightTexture.func_228454_b_((int)brightness);
                    this.b[x][y][z] = LightTexture.func_228450_a_((int)brightness);
                    this.ao[x][y][z] = state.func_215703_d((IBlockReader)this.world, pos);
                }
            }
        }
        Direction[] x = SIDES;
        y = x.length;
        for (z = 0; z < y; ++z) {
            BlockState otherStateShape;
            Direction side = x[z];
            BlockPos pos = this.blockPos.func_177972_a(side);
            BlockState state = this.world.func_180495_p(pos);
            BlockState thisStateShape = this.state.func_200132_m() && this.state.func_215691_g() ? this.state : Blocks.field_150350_a.func_176223_P();
            BlockState blockState = otherStateShape = state.func_200132_m() && state.func_215691_g() ? state : Blocks.field_150350_a.func_176223_P();
            if (state.func_200016_a((IBlockReader)this.world, pos) != 15 && !VoxelShapes.func_223416_b((VoxelShape)thisStateShape.func_215702_a((IBlockReader)this.world, this.blockPos, side), (VoxelShape)otherStateShape.func_215702_a((IBlockReader)this.world, pos, side.func_176734_d()))) continue;
            int x2 = side.func_82601_c() + 1;
            int y2 = side.func_96559_d() + 1;
            int z2 = side.func_82599_e() + 1;
            this.s[x2][y2][z2] = Math.max(this.s[1][1][1] - 1, this.s[x2][y2][z2]);
            this.b[x2][y2][z2] = Math.max(this.b[1][1][1] - 1, this.b[x2][y2][z2]);
        }
        for (int x3 = 0; x3 < 2; ++x3) {
            for (y = 0; y < 2; ++y) {
                for (z = 0; z < 2; ++z) {
                    int x1 = x3 * 2;
                    int y1 = y * 2;
                    int z1 = z * 2;
                    int sxyz = this.s[x1][y1][z1];
                    int bxyz = this.b[x1][y1][z1];
                    boolean txyz = this.t[x1][y1][z1];
                    int sxz = this.s[x1][1][z1];
                    int sxy = this.s[x1][y1][1];
                    int syz = this.s[1][y1][z1];
                    int bxz = this.b[x1][1][z1];
                    int bxy = this.b[x1][y1][1];
                    int byz = this.b[1][y1][z1];
                    boolean txz = this.t[x1][1][z1];
                    boolean txy = this.t[x1][y1][1];
                    boolean tyz = this.t[1][y1][z1];
                    int sx = this.s[x1][1][1];
                    int sy = this.s[1][y1][1];
                    int sz = this.s[1][1][z1];
                    int bx = this.b[x1][1][1];
                    int by = this.b[1][y1][1];
                    int bz = this.b[1][1][z1];
                    boolean tx = this.t[x1][1][1];
                    boolean ty = this.t[1][y1][1];
                    boolean tz = this.t[1][1][z1];
                    this.skyLight[0][x3][y][z] = this.combine(sx, sxz, sxy, txz || txy ? sxyz : sx, tx, txz, txy, txz || txy ? txyz : tx);
                    this.blockLight[0][x3][y][z] = this.combine(bx, bxz, bxy, txz || txy ? bxyz : bx, tx, txz, txy, txz || txy ? txyz : tx);
                    this.skyLight[1][x3][y][z] = this.combine(sy, sxy, syz, txy || tyz ? sxyz : sy, ty, txy, tyz, txy || tyz ? txyz : ty);
                    this.blockLight[1][x3][y][z] = this.combine(by, bxy, byz, txy || tyz ? bxyz : by, ty, txy, tyz, txy || tyz ? txyz : ty);
                    this.skyLight[2][x3][y][z] = this.combine(sz, syz, sxz, tyz || txz ? sxyz : sz, tz, tyz, txz, tyz || txz ? txyz : tz);
                    this.blockLight[2][x3][y][z] = this.combine(bz, byz, bxz, tyz || txz ? bxyz : bz, tz, tyz, txz, tyz || txz ? txyz : tz);
                }
            }
        }
    }

    public void updateFlatLighting() {
        this.full = Block.func_208062_a((VoxelShape)this.state.func_196952_d((IBlockReader)this.world, this.blockPos));
        this.packed[0] = WorldRenderer.func_228421_a_((IBlockDisplayReader)this.world, (BlockPos)this.blockPos);
        for (Direction side : SIDES) {
            int i = side.ordinal() + 1;
            this.packed[i] = WorldRenderer.func_228421_a_((IBlockDisplayReader)this.world, (BlockPos)this.blockPos.func_177972_a(side));
        }
    }

    public IBlockDisplayReader getWorld() {
        return this.world;
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public boolean[][][] getTranslucent() {
        return this.t;
    }

    public float[][][][] getSkyLight() {
        return this.skyLight;
    }

    public float[][][][] getBlockLight() {
        return this.blockLight;
    }

    public float[][][] getAo() {
        return this.ao;
    }

    public int[] getPackedLight() {
        return this.packed;
    }

    public boolean isFullCube() {
        return this.full;
    }

    @Deprecated
    public float getShx() {
        return 0.0f;
    }

    @Deprecated
    public float getShy() {
        return 0.0f;
    }

    @Deprecated
    public float getShz() {
        return 0.0f;
    }

    public int getCachedTint() {
        return this.cachedTint;
    }

    public int getCachedMultiplier() {
        return this.cachedMultiplier;
    }
}

